// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> True - Value originates from workspace retention in days, False - Customer specific. </summary>
    public readonly partial struct RetentionInDaysAsDefaultState : IEquatable<RetentionInDaysAsDefaultState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RetentionInDaysAsDefaultState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RetentionInDaysAsDefaultState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> Value originates from workspace retention in days. </summary>
        public static RetentionInDaysAsDefaultState True { get; } = new RetentionInDaysAsDefaultState(TrueValue);
        /// <summary> Value is customer specific. </summary>
        public static RetentionInDaysAsDefaultState False { get; } = new RetentionInDaysAsDefaultState(FalseValue);
        /// <summary> Determines if two <see cref="RetentionInDaysAsDefaultState"/> values are the same. </summary>
        public static bool operator ==(RetentionInDaysAsDefaultState left, RetentionInDaysAsDefaultState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RetentionInDaysAsDefaultState"/> values are not the same. </summary>
        public static bool operator !=(RetentionInDaysAsDefaultState left, RetentionInDaysAsDefaultState right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="RetentionInDaysAsDefaultState"/>. </summary>
        public static implicit operator RetentionInDaysAsDefaultState(string value) => new RetentionInDaysAsDefaultState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RetentionInDaysAsDefaultState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RetentionInDaysAsDefaultState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value?.GetHashCode() ?? 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
