// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.EnergyServices.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableEnergyServicesArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableEnergyServicesArmClient"/> class for mocking. </summary>
        protected MockableEnergyServicesArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableEnergyServicesArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableEnergyServicesArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableEnergyServicesArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="EnergyServiceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="EnergyServiceResource.CreateResourceIdentifier" /> to create an <see cref="EnergyServiceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="EnergyServiceResource"/> object. </returns>
        public virtual EnergyServiceResource GetEnergyServiceResource(ResourceIdentifier id)
        {
            EnergyServiceResource.ValidateResourceId(id);
            return new EnergyServiceResource(Client, id);
        }
    }
}
