// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EnergyServices.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmEnergyServicesModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.EnergyServiceNameAvailabilityResult"/>. </summary>
        /// <param name="nameAvailable"> Indicates if the resource name is available. </param>
        /// <param name="reason"> The reason why the given name is not available. </param>
        /// <param name="message"> Detailed reason why the given name is available. </param>
        /// <returns> A new <see cref="Models.EnergyServiceNameAvailabilityResult"/> instance for mocking. </returns>
        public static EnergyServiceNameAvailabilityResult EnergyServiceNameAvailabilityResult(bool? nameAvailable = null, EnergyServiceNameUnavailableReason? reason = null, string message = null)
        {
            return new EnergyServiceNameAvailabilityResult(nameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="EnergyServices.EnergyServiceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="EnergyServices.EnergyServiceData"/> instance for mocking. </returns>
        public static EnergyServiceData EnergyServiceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, EnergyServiceProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new EnergyServiceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EnergyServiceProperties"/>. </summary>
        /// <param name="dnsName"></param>
        /// <param name="provisioningState"></param>
        /// <param name="authAppId"></param>
        /// <param name="dataPartitionNames"></param>
        /// <returns> A new <see cref="Models.EnergyServiceProperties"/> instance for mocking. </returns>
        public static EnergyServiceProperties EnergyServiceProperties(string dnsName = null, ProvisioningState? provisioningState = null, string authAppId = null, IEnumerable<DataPartitionName> dataPartitionNames = null)
        {
            dataPartitionNames ??= new List<DataPartitionName>();

            return new EnergyServiceProperties(dnsName, provisioningState, authAppId, dataPartitionNames?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataPartitionsListResult"/>. </summary>
        /// <param name="dataPartitionInfo"> List of data partitions along with their properties in a given OEP resource. </param>
        /// <returns> A new <see cref="Models.DataPartitionsListResult"/> instance for mocking. </returns>
        public static DataPartitionsListResult DataPartitionsListResult(IEnumerable<DataPartition> dataPartitionInfo = null)
        {
            dataPartitionInfo ??= new List<DataPartition>();

            return new DataPartitionsListResult(dataPartitionInfo?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataPartition"/>. </summary>
        /// <param name="name"> Name of the data partition. </param>
        /// <param name="provisioningState"> Name of the data partition. </param>
        /// <returns> A new <see cref="Models.DataPartition"/> instance for mocking. </returns>
        public static DataPartition DataPartition(string name = null, string provisioningState = null)
        {
            return new DataPartition(name, provisioningState, serializedAdditionalRawData: null);
        }
    }
}
