// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI.Chat
{
    /// <summary> The MongoDBChatDataSourceParameters. </summary>
    internal partial class InternalMongoDBChatDataSourceParameters
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        internal IDictionary<string, BinaryData> SerializedAdditionalRawData { get; set; }
        /// <summary> Initializes a new instance of <see cref="InternalMongoDBChatDataSourceParameters"/>. </summary>
        /// <param name="endpoint"> The name of the MongoDB cluster endpoint. </param>
        /// <param name="databaseName"> The name of the MongoDB database. </param>
        /// <param name="collectionName"> The name of the MongoDB collection. </param>
        /// <param name="appName"> The name of the MongoDB application. </param>
        /// <param name="indexName"> The name of the MongoDB index. </param>
        /// <param name="authentication">
        /// The authentication mechanism to use with Pinecone.
        /// Supported authentication mechanisms for Pinecone include: username and password.
        /// Please note <see cref="DataSourceAuthentication"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes..
        /// </param>
        /// <param name="embeddingDependency">
        /// The vectorization source to use as an embedding dependency for the MongoDB data source.
        /// Supported vectorization sources for MongoDB include: endpoint, deployment name.
        /// Please note <see cref="DataSourceVectorizer"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes..
        /// </param>
        /// <param name="fieldMappings">
        /// Field mappings to apply to data used by the MongoDB data source.
        /// Note that content and vector field mappings are required for MongoDB.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/>, <paramref name="databaseName"/>, <paramref name="collectionName"/>, <paramref name="appName"/>, <paramref name="indexName"/>, <paramref name="authentication"/>, <paramref name="embeddingDependency"/> or <paramref name="fieldMappings"/> is null. </exception>
        public InternalMongoDBChatDataSourceParameters(string endpoint, string databaseName, string collectionName, string appName, string indexName, DataSourceAuthentication authentication, DataSourceVectorizer embeddingDependency, DataSourceFieldMappings fieldMappings)
        {
            Argument.AssertNotNull(endpoint, nameof(endpoint));
            Argument.AssertNotNull(databaseName, nameof(databaseName));
            Argument.AssertNotNull(collectionName, nameof(collectionName));
            Argument.AssertNotNull(appName, nameof(appName));
            Argument.AssertNotNull(indexName, nameof(indexName));
            Argument.AssertNotNull(authentication, nameof(authentication));
            Argument.AssertNotNull(embeddingDependency, nameof(embeddingDependency));
            Argument.AssertNotNull(fieldMappings, nameof(fieldMappings));

            _internalIncludeContexts = new ChangeTrackingList<string>();
            Endpoint = endpoint;
            DatabaseName = databaseName;
            CollectionName = collectionName;
            AppName = appName;
            IndexName = indexName;
            Authentication = authentication;
            EmbeddingDependency = embeddingDependency;
            FieldMappings = fieldMappings;
        }

        /// <summary> Initializes a new instance of <see cref="InternalMongoDBChatDataSourceParameters"/>. </summary>
        /// <param name="topNDocuments"> The configured number of documents to feature in the query. </param>
        /// <param name="inScope"> Whether queries should be restricted to use of the indexed data. </param>
        /// <param name="strictness">
        /// The configured strictness of the search relevance filtering.
        /// Higher strictness will increase precision but lower recall of the answer.
        /// </param>
        /// <param name="maxSearchQueries">
        /// The maximum number of rewritten queries that should be sent to the search provider for a single user message.
        /// By default, the system will make an automatic determination.
        /// </param>
        /// <param name="allowPartialResult">
        /// If set to true, the system will allow partial search results to be used and the request will fail if all
        /// partial queries fail. If not specified or specified as false, the request will fail if any search query fails.
        /// </param>
        /// <param name="internalIncludeContexts">
        /// The output context properties to include on the response.
        /// By default, citations and intent will be requested.
        /// </param>
        /// <param name="endpoint"> The name of the MongoDB cluster endpoint. </param>
        /// <param name="databaseName"> The name of the MongoDB database. </param>
        /// <param name="collectionName"> The name of the MongoDB collection. </param>
        /// <param name="appName"> The name of the MongoDB application. </param>
        /// <param name="indexName"> The name of the MongoDB index. </param>
        /// <param name="authentication">
        /// The authentication mechanism to use with Pinecone.
        /// Supported authentication mechanisms for Pinecone include: username and password.
        /// Please note <see cref="DataSourceAuthentication"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes..
        /// </param>
        /// <param name="embeddingDependency">
        /// The vectorization source to use as an embedding dependency for the MongoDB data source.
        /// Supported vectorization sources for MongoDB include: endpoint, deployment name.
        /// Please note <see cref="DataSourceVectorizer"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes..
        /// </param>
        /// <param name="fieldMappings">
        /// Field mappings to apply to data used by the MongoDB data source.
        /// Note that content and vector field mappings are required for MongoDB.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InternalMongoDBChatDataSourceParameters(int? topNDocuments, bool? inScope, int? strictness, int? maxSearchQueries, bool? allowPartialResult, IList<string> internalIncludeContexts, string endpoint, string databaseName, string collectionName, string appName, string indexName, DataSourceAuthentication authentication, DataSourceVectorizer embeddingDependency, DataSourceFieldMappings fieldMappings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TopNDocuments = topNDocuments;
            InScope = inScope;
            Strictness = strictness;
            MaxSearchQueries = maxSearchQueries;
            AllowPartialResult = allowPartialResult;
            _internalIncludeContexts = internalIncludeContexts;
            Endpoint = endpoint;
            DatabaseName = databaseName;
            CollectionName = collectionName;
            AppName = appName;
            IndexName = indexName;
            Authentication = authentication;
            EmbeddingDependency = embeddingDependency;
            FieldMappings = fieldMappings;
            SerializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="InternalMongoDBChatDataSourceParameters"/> for deserialization. </summary>
        internal InternalMongoDBChatDataSourceParameters()
        {
        }

        /// <summary> The configured number of documents to feature in the query. </summary>
        public int? TopNDocuments { get; set; }
        /// <summary> Whether queries should be restricted to use of the indexed data. </summary>
        public bool? InScope { get; set; }
        /// <summary>
        /// The configured strictness of the search relevance filtering.
        /// Higher strictness will increase precision but lower recall of the answer.
        /// </summary>
        public int? Strictness { get; set; }
        /// <summary>
        /// The maximum number of rewritten queries that should be sent to the search provider for a single user message.
        /// By default, the system will make an automatic determination.
        /// </summary>
        public int? MaxSearchQueries { get; set; }
        /// <summary>
        /// If set to true, the system will allow partial search results to be used and the request will fail if all
        /// partial queries fail. If not specified or specified as false, the request will fail if any search query fails.
        /// </summary>
        public bool? AllowPartialResult { get; set; }
        /// <summary> The name of the MongoDB cluster endpoint. </summary>
        internal string Endpoint { get; set; }
        /// <summary> The name of the MongoDB database. </summary>
        internal string DatabaseName { get; set; }
        /// <summary> The name of the MongoDB collection. </summary>
        internal string CollectionName { get; set; }
        /// <summary> The name of the MongoDB application. </summary>
        internal string AppName { get; set; }
        /// <summary> The name of the MongoDB index. </summary>
        internal string IndexName { get; set; }
    }
}

