// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI
{
    /// <summary>
    /// A content filter result item that associates an existing custom blocklist ID with a value indicating whether or not
    /// the corresponding blocklist resulted in content being filtered.
    /// </summary>
    internal partial class InternalAzureContentFilterBlocklistIdResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        internal IDictionary<string, BinaryData> SerializedAdditionalRawData { get; set; }
        /// <summary> Initializes a new instance of <see cref="InternalAzureContentFilterBlocklistIdResult"/>. </summary>
        /// <param name="id"> The ID of the custom blocklist associated with the filtered status. </param>
        /// <param name="filtered"> Whether the associated blocklist resulted in the content being filtered. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        internal InternalAzureContentFilterBlocklistIdResult(string id, bool filtered)
        {
            Argument.AssertNotNull(id, nameof(id));

            Id = id;
            Filtered = filtered;
        }

        /// <summary> Initializes a new instance of <see cref="InternalAzureContentFilterBlocklistIdResult"/>. </summary>
        /// <param name="id"> The ID of the custom blocklist associated with the filtered status. </param>
        /// <param name="filtered"> Whether the associated blocklist resulted in the content being filtered. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InternalAzureContentFilterBlocklistIdResult(string id, bool filtered, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Filtered = filtered;
            SerializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="InternalAzureContentFilterBlocklistIdResult"/> for deserialization. </summary>
        internal InternalAzureContentFilterBlocklistIdResult()
        {
        }

        /// <summary> The ID of the custom blocklist associated with the filtered status. </summary>
        internal string Id { get; set; }
        /// <summary> Whether the associated blocklist resulted in the content being filtered. </summary>
        internal bool Filtered { get; set; }
    }
}

