// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI.Chat
{
    /// <summary> Represents a vectorization source that makes public service calls against an Azure OpenAI embedding model deployment. </summary>
    internal partial class InternalAzureChatDataSourceEndpointVectorizationSource : DataSourceVectorizer
    {
        /// <summary> Initializes a new instance of <see cref="InternalAzureChatDataSourceEndpointVectorizationSource"/>. </summary>
        /// <param name="endpoint">
        /// Specifies the resource endpoint URL from which embeddings should be retrieved.
        /// It should be in the format of:
        /// https://YOUR_RESOURCE_NAME.openai.azure.com/openai/deployments/YOUR_DEPLOYMENT_NAME/embeddings.
        /// The api-version query parameter is not allowed.
        /// </param>
        /// <param name="authentication">
        /// The authentication mechanism to use with the endpoint-based vectorization source.
        /// Endpoint authentication supports API key and access token mechanisms.
        /// Please note <see cref="DataSourceAuthentication"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes..
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="authentication"/> is null. </exception>
        public InternalAzureChatDataSourceEndpointVectorizationSource(Uri endpoint, DataSourceAuthentication authentication)
        {
            Argument.AssertNotNull(endpoint, nameof(endpoint));
            Argument.AssertNotNull(authentication, nameof(authentication));

            Type = "endpoint";
            Endpoint = endpoint;
            Authentication = authentication;
        }

        /// <summary> Initializes a new instance of <see cref="InternalAzureChatDataSourceEndpointVectorizationSource"/>. </summary>
        /// <param name="type"> The differentiating identifier for the concrete vectorization source. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="endpoint">
        /// Specifies the resource endpoint URL from which embeddings should be retrieved.
        /// It should be in the format of:
        /// https://YOUR_RESOURCE_NAME.openai.azure.com/openai/deployments/YOUR_DEPLOYMENT_NAME/embeddings.
        /// The api-version query parameter is not allowed.
        /// </param>
        /// <param name="authentication">
        /// The authentication mechanism to use with the endpoint-based vectorization source.
        /// Endpoint authentication supports API key and access token mechanisms.
        /// Please note <see cref="DataSourceAuthentication"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes..
        /// </param>
        /// <param name="dimensions">
        /// The number of dimensions to request on embeddings.
        /// Only supported in 'text-embedding-3' and later models.
        /// </param>
        internal InternalAzureChatDataSourceEndpointVectorizationSource(string type, IDictionary<string, BinaryData> serializedAdditionalRawData, Uri endpoint, DataSourceAuthentication authentication, int? dimensions) : base(type, serializedAdditionalRawData)
        {
            Endpoint = endpoint;
            Authentication = authentication;
            Dimensions = dimensions;
        }

        /// <summary> Initializes a new instance of <see cref="InternalAzureChatDataSourceEndpointVectorizationSource"/> for deserialization. </summary>
        internal InternalAzureChatDataSourceEndpointVectorizationSource()
        {
        }

        /// <summary>
        /// Specifies the resource endpoint URL from which embeddings should be retrieved.
        /// It should be in the format of:
        /// https://YOUR_RESOURCE_NAME.openai.azure.com/openai/deployments/YOUR_DEPLOYMENT_NAME/embeddings.
        /// The api-version query parameter is not allowed.
        /// </summary>
        internal Uri Endpoint { get; set; }
        /// <summary>
        /// The number of dimensions to request on embeddings.
        /// Only supported in 'text-embedding-3' and later models.
        /// </summary>
        public int? Dimensions { get; set; }
    }
}

