// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Chat
{
    /// <summary> The AzureSearchChatDataSourceParametersQueryType. </summary>
    public readonly partial struct DataSourceQueryType : IEquatable<DataSourceQueryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataSourceQueryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataSourceQueryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SimpleValue = "simple";
        private const string SemanticValue = "semantic";
        private const string VectorValue = "vector";
        private const string VectorSimpleHybridValue = "vector_simple_hybrid";
        private const string VectorSemanticHybridValue = "vector_semantic_hybrid";

        /// <summary> simple. </summary>
        public static DataSourceQueryType Simple { get; } = new DataSourceQueryType(SimpleValue);
        /// <summary> semantic. </summary>
        public static DataSourceQueryType Semantic { get; } = new DataSourceQueryType(SemanticValue);
        /// <summary> vector. </summary>
        public static DataSourceQueryType Vector { get; } = new DataSourceQueryType(VectorValue);
        /// <summary> vector_simple_hybrid. </summary>
        public static DataSourceQueryType VectorSimpleHybrid { get; } = new DataSourceQueryType(VectorSimpleHybridValue);
        /// <summary> vector_semantic_hybrid. </summary>
        public static DataSourceQueryType VectorSemanticHybrid { get; } = new DataSourceQueryType(VectorSemanticHybridValue);
        /// <summary> Determines if two <see cref="DataSourceQueryType"/> values are the same. </summary>
        public static bool operator ==(DataSourceQueryType left, DataSourceQueryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataSourceQueryType"/> values are not the same. </summary>
        public static bool operator !=(DataSourceQueryType left, DataSourceQueryType right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="DataSourceQueryType"/>. </summary>
        public static implicit operator DataSourceQueryType(string value) => new DataSourceQueryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataSourceQueryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataSourceQueryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
