// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI
{
    /// <summary>
    /// A labeled content filter result item that indicates whether the content was filtered and what the qualitative
    /// severity level of the content was, as evaluated against content filter configuration for the category.
    /// </summary>
    public partial class ContentFilterSeverityResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        internal IDictionary<string, BinaryData> SerializedAdditionalRawData { get; set; }
        /// <summary> Initializes a new instance of <see cref="ContentFilterSeverityResult"/>. </summary>
        /// <param name="filtered"> Whether the content severity resulted in a content filtering action. </param>
        /// <param name="severity"> The labeled severity of the content. </param>
        internal ContentFilterSeverityResult(bool filtered, ContentFilterSeverity severity)
        {
            Filtered = filtered;
            Severity = severity;
        }

        /// <summary> Initializes a new instance of <see cref="ContentFilterSeverityResult"/>. </summary>
        /// <param name="filtered"> Whether the content severity resulted in a content filtering action. </param>
        /// <param name="severity"> The labeled severity of the content. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContentFilterSeverityResult(bool filtered, ContentFilterSeverity severity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Filtered = filtered;
            Severity = severity;
            SerializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContentFilterSeverityResult"/> for deserialization. </summary>
        internal ContentFilterSeverityResult()
        {
        }

        /// <summary> Whether the content severity resulted in a content filtering action. </summary>
        public bool Filtered { get; }
    }
}
