// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI
{
    /// <summary> A collection of true/false filtering results for configured custom blocklists. </summary>
    public partial class ContentFilterBlocklistResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        internal IDictionary<string, BinaryData> SerializedAdditionalRawData { get; set; }
        /// <summary> Initializes a new instance of <see cref="ContentFilterBlocklistResult"/>. </summary>
        /// <param name="filtered"> A value indicating whether any of the detailed blocklists resulted in a filtering action. </param>
        internal ContentFilterBlocklistResult(bool filtered)
        {
            Filtered = filtered;
            InternalDetails = new ChangeTrackingList<InternalAzureContentFilterBlocklistResultDetail>();
        }

        /// <summary> Initializes a new instance of <see cref="ContentFilterBlocklistResult"/>. </summary>
        /// <param name="filtered"> A value indicating whether any of the detailed blocklists resulted in a filtering action. </param>
        /// <param name="internalDetails"> The pairs of individual blocklist IDs and whether they resulted in a filtering action. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContentFilterBlocklistResult(bool filtered, IReadOnlyList<InternalAzureContentFilterBlocklistResultDetail> internalDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Filtered = filtered;
            InternalDetails = internalDetails;
            SerializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContentFilterBlocklistResult"/> for deserialization. </summary>
        internal ContentFilterBlocklistResult()
        {
        }

        /// <summary> A value indicating whether any of the detailed blocklists resulted in a filtering action. </summary>
        public bool Filtered { get; }
    }
}
