// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.OpenAI.Chat
{
    /// <summary> The AzureChatMessageContextAllRetrievedDocuments. </summary>
    public partial class ChatRetrievedDocument
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        internal IDictionary<string, BinaryData> SerializedAdditionalRawData { get; set; }
        /// <summary> Initializes a new instance of <see cref="ChatRetrievedDocument"/>. </summary>
        /// <param name="content"> The content of the citation. </param>
        /// <param name="searchQueries"> The search queries executed to retrieve documents. </param>
        /// <param name="dataSourceIndex"> The index of the data source used for retrieval. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> or <paramref name="searchQueries"/> is null. </exception>
        internal ChatRetrievedDocument(string content, IEnumerable<string> searchQueries, int dataSourceIndex)
        {
            Argument.AssertNotNull(content, nameof(content));
            Argument.AssertNotNull(searchQueries, nameof(searchQueries));

            Content = content;
            SearchQueries = searchQueries.ToList();
            DataSourceIndex = dataSourceIndex;
        }

        /// <summary> Initializes a new instance of <see cref="ChatRetrievedDocument"/>. </summary>
        /// <param name="content"> The content of the citation. </param>
        /// <param name="title"> The title for the citation. </param>
        /// <param name="uri"> The URL of the citation. </param>
        /// <param name="filePath"> The file path for the citation. </param>
        /// <param name="chunkId"> The chunk ID for the citation. </param>
        /// <param name="rerankScore"> The rerank score for the retrieval. </param>
        /// <param name="searchQueries"> The search queries executed to retrieve documents. </param>
        /// <param name="dataSourceIndex"> The index of the data source used for retrieval. </param>
        /// <param name="originalSearchScore"> The original search score for the retrieval. </param>
        /// <param name="filterReason"> If applicable, an indication of why the document was filtered. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChatRetrievedDocument(string content, string title, Uri uri, string filePath, string chunkId, double? rerankScore, IReadOnlyList<string> searchQueries, int dataSourceIndex, double? originalSearchScore, ChatDocumentFilterReason? filterReason, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Content = content;
            Title = title;
            Uri = uri;
            FilePath = filePath;
            ChunkId = chunkId;
            RerankScore = rerankScore;
            SearchQueries = searchQueries;
            DataSourceIndex = dataSourceIndex;
            OriginalSearchScore = originalSearchScore;
            FilterReason = filterReason;
            SerializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ChatRetrievedDocument"/> for deserialization. </summary>
        internal ChatRetrievedDocument()
        {
        }

        /// <summary> The content of the citation. </summary>
        public string Content { get; }
        /// <summary> The title for the citation. </summary>
        public string Title { get; }
        /// <summary> The chunk ID for the citation. </summary>
        public string ChunkId { get; }
        /// <summary> The rerank score for the retrieval. </summary>
        public double? RerankScore { get; }
        /// <summary> The search queries executed to retrieve documents. </summary>
        public IReadOnlyList<string> SearchQueries { get; }
        /// <summary> The index of the data source used for retrieval. </summary>
        public int DataSourceIndex { get; }
        /// <summary> The original search score for the retrieval. </summary>
        public double? OriginalSearchScore { get; }
        /// <summary> If applicable, an indication of why the document was filtered. </summary>
        public ChatDocumentFilterReason? FilterReason { get; }
    }
}
