// <auto-generated/>

#nullable disable

using System;
using System.ClientModel;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.OpenAI.Chat
{
    public partial class ChatRetrievedDocument : IJsonModel<ChatRetrievedDocument>
    {
        void IJsonModel<ChatRetrievedDocument>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChatRetrievedDocument>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ChatRetrievedDocument)} does not support writing '{format}' format.");
            }

            writer.WriteStartObject();
            if (SerializedAdditionalRawData?.ContainsKey("content") != true)
            {
                writer.WritePropertyName("content"u8);
                writer.WriteStringValue(Content);
            }
            if (SerializedAdditionalRawData?.ContainsKey("title") != true && Optional.IsDefined(Title))
            {
                writer.WritePropertyName("title"u8);
                writer.WriteStringValue(Title);
            }
            if (SerializedAdditionalRawData?.ContainsKey("url") != true && Optional.IsDefined(Uri))
            {
                writer.WritePropertyName("url"u8);
                writer.WriteStringValue(Uri.AbsoluteUri);
            }
            if (SerializedAdditionalRawData?.ContainsKey("filepath") != true && Optional.IsDefined(FilePath))
            {
                writer.WritePropertyName("filepath"u8);
                writer.WriteStringValue(FilePath);
            }
            if (SerializedAdditionalRawData?.ContainsKey("chunk_id") != true && Optional.IsDefined(ChunkId))
            {
                writer.WritePropertyName("chunk_id"u8);
                writer.WriteStringValue(ChunkId);
            }
            if (SerializedAdditionalRawData?.ContainsKey("rerank_score") != true && Optional.IsDefined(RerankScore))
            {
                writer.WritePropertyName("rerank_score"u8);
                writer.WriteNumberValue(RerankScore.Value);
            }
            if (SerializedAdditionalRawData?.ContainsKey("search_queries") != true)
            {
                writer.WritePropertyName("search_queries"u8);
                writer.WriteStartArray();
                foreach (var item in SearchQueries)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (SerializedAdditionalRawData?.ContainsKey("data_source_index") != true)
            {
                writer.WritePropertyName("data_source_index"u8);
                writer.WriteNumberValue(DataSourceIndex);
            }
            if (SerializedAdditionalRawData?.ContainsKey("original_search_score") != true && Optional.IsDefined(OriginalSearchScore))
            {
                writer.WritePropertyName("original_search_score"u8);
                writer.WriteNumberValue(OriginalSearchScore.Value);
            }
            if (SerializedAdditionalRawData?.ContainsKey("filter_reason") != true && Optional.IsDefined(FilterReason))
            {
                writer.WritePropertyName("filter_reason"u8);
                writer.WriteStringValue(FilterReason.Value.ToString());
            }
            if (SerializedAdditionalRawData != null)
            {
                foreach (var item in SerializedAdditionalRawData)
                {
                    if (ModelSerializationExtensions.IsSentinelValue(item.Value))
                    {
                        continue;
                    }
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
            writer.WriteEndObject();
        }

        ChatRetrievedDocument IJsonModel<ChatRetrievedDocument>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChatRetrievedDocument>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ChatRetrievedDocument)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeChatRetrievedDocument(document.RootElement, options);
        }

        internal static ChatRetrievedDocument DeserializeChatRetrievedDocument(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string content = default;
            string title = default;
            Uri url = default;
            string filepath = default;
            string chunkId = default;
            double? rerankScore = default;
            IReadOnlyList<string> searchQueries = default;
            int dataSourceIndex = default;
            double? originalSearchScore = default;
            ChatDocumentFilterReason? filterReason = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("content"u8))
                {
                    content = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("title"u8))
                {
                    title = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("url"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    url = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("filepath"u8))
                {
                    filepath = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("chunk_id"u8))
                {
                    chunkId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("rerank_score"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rerankScore = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("search_queries"u8))
                {
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    searchQueries = array;
                    continue;
                }
                if (property.NameEquals("data_source_index"u8))
                {
                    dataSourceIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("original_search_score"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    originalSearchScore = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("filter_reason"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    filterReason = new ChatDocumentFilterReason(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary ??= new Dictionary<string, BinaryData>();
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ChatRetrievedDocument(
                content,
                title,
                url,
                filepath,
                chunkId,
                rerankScore,
                searchQueries,
                dataSourceIndex,
                originalSearchScore,
                filterReason,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ChatRetrievedDocument>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChatRetrievedDocument>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ChatRetrievedDocument)} does not support writing '{options.Format}' format.");
            }
        }

        ChatRetrievedDocument IPersistableModel<ChatRetrievedDocument>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChatRetrievedDocument>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeChatRetrievedDocument(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ChatRetrievedDocument)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ChatRetrievedDocument>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The result to deserialize the model from. </param>
        internal static ChatRetrievedDocument FromResponse(PipelineResponse response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeChatRetrievedDocument(document.RootElement);
        }

        /// <summary> Convert into a <see cref="BinaryContent"/>. </summary>
        internal virtual BinaryContent ToBinaryContent()
        {
            return BinaryContent.Create(this, ModelSerializationExtensions.WireOptions);
        }
    }
}
