// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI.Chat
{
    /// <summary>
    /// An additional property, added to chat completion response messages, produced by the Azure OpenAI service when using
    /// extension behavior. This includes intent and citation information from the On Your Data feature.
    /// </summary>
    public partial class ChatMessageContext
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        internal IDictionary<string, BinaryData> SerializedAdditionalRawData { get; set; }
        /// <summary> Initializes a new instance of <see cref="ChatMessageContext"/>. </summary>
        internal ChatMessageContext()
        {
            Citations = new ChangeTrackingList<ChatCitation>();
        }

        /// <summary> Initializes a new instance of <see cref="ChatMessageContext"/>. </summary>
        /// <param name="intent"> The detected intent from the chat history, which is used to carry conversation context between interactions. </param>
        /// <param name="citations"> The citations produced by the data retrieval. </param>
        /// <param name="retrievedDocuments"> Summary information about documents retrieved by the data retrieval operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChatMessageContext(string intent, IReadOnlyList<ChatCitation> citations, ChatRetrievedDocument retrievedDocuments, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Intent = intent;
            Citations = citations;
            RetrievedDocuments = retrievedDocuments;
            SerializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The detected intent from the chat history, which is used to carry conversation context between interactions. </summary>
        public string Intent { get; }
        /// <summary> The citations produced by the data retrieval. </summary>
        public IReadOnlyList<ChatCitation> Citations { get; }
    }
}
