// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Chat
{
    /// <summary> The AzureChatMessageContextAllRetrievedDocumentsFilterReason. </summary>
    public readonly partial struct ChatDocumentFilterReason : IEquatable<ChatDocumentFilterReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ChatDocumentFilterReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ChatDocumentFilterReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ScoreValue = "score";
        private const string RerankValue = "rerank";

        /// <summary> score. </summary>
        public static ChatDocumentFilterReason Score { get; } = new ChatDocumentFilterReason(ScoreValue);
        /// <summary> rerank. </summary>
        public static ChatDocumentFilterReason Rerank { get; } = new ChatDocumentFilterReason(RerankValue);
        /// <summary> Determines if two <see cref="ChatDocumentFilterReason"/> values are the same. </summary>
        public static bool operator ==(ChatDocumentFilterReason left, ChatDocumentFilterReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ChatDocumentFilterReason"/> values are not the same. </summary>
        public static bool operator !=(ChatDocumentFilterReason left, ChatDocumentFilterReason right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="ChatDocumentFilterReason"/>. </summary>
        public static implicit operator ChatDocumentFilterReason(string value) => new ChatDocumentFilterReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ChatDocumentFilterReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ChatDocumentFilterReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
