// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.IO;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The UploadFileRequest. </summary>
    internal partial class UploadFileRequest
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UploadFileRequest"/>. </summary>
        /// <param name="data"> The file data (not filename) to upload. </param>
        /// <param name="purpose"> The intended purpose of the file. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        internal UploadFileRequest(Stream data, OpenAIFilePurpose purpose)
        {
            Argument.AssertNotNull(data, nameof(data));

            Data = data;
            Purpose = purpose;
        }

        /// <summary> Initializes a new instance of <see cref="UploadFileRequest"/>. </summary>
        /// <param name="data"> The file data (not filename) to upload. </param>
        /// <param name="purpose"> The intended purpose of the file. </param>
        /// <param name="filename"> A filename to associate with the uploaded data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UploadFileRequest(Stream data, OpenAIFilePurpose purpose, string filename, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Data = data;
            Purpose = purpose;
            Filename = filename;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UploadFileRequest"/> for deserialization. </summary>
        internal UploadFileRequest()
        {
        }

        /// <summary> The file data (not filename) to upload. </summary>
        public Stream Data { get; }
        /// <summary> The intended purpose of the file. </summary>
        public OpenAIFilePurpose Purpose { get; }
        /// <summary> A filename to associate with the uploaded data. </summary>
        public string Filename { get; }
    }
}
