// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The SubmitToolOutputsToRunRequest. </summary>
    internal partial class SubmitToolOutputsToRunRequest
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SubmitToolOutputsToRunRequest"/>. </summary>
        /// <param name="toolOutputs"> The list of tool outputs requested by tool calls from the specified run. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="toolOutputs"/> is null. </exception>
        internal SubmitToolOutputsToRunRequest(IEnumerable<ToolOutput> toolOutputs)
        {
            Argument.AssertNotNull(toolOutputs, nameof(toolOutputs));

            ToolOutputs = toolOutputs.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="SubmitToolOutputsToRunRequest"/>. </summary>
        /// <param name="toolOutputs"> The list of tool outputs requested by tool calls from the specified run. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SubmitToolOutputsToRunRequest(IReadOnlyList<ToolOutput> toolOutputs, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ToolOutputs = toolOutputs;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SubmitToolOutputsToRunRequest"/> for deserialization. </summary>
        internal SubmitToolOutputsToRunRequest()
        {
        }

        /// <summary> The list of tool outputs requested by tool calls from the specified run. </summary>
        public IReadOnlyList<ToolOutput> ToolOutputs { get; }
    }
}
