// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The possible types of run steps. </summary>
    public readonly partial struct RunStepType : IEquatable<RunStepType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RunStepType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RunStepType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MessageCreationValue = "message_creation";
        private const string ToolCallsValue = "tool_calls";

        /// <summary> Represents a run step to create a message. </summary>
        public static RunStepType MessageCreation { get; } = new RunStepType(MessageCreationValue);
        /// <summary> Represents a run step that calls tools. </summary>
        public static RunStepType ToolCalls { get; } = new RunStepType(ToolCallsValue);
        /// <summary> Determines if two <see cref="RunStepType"/> values are the same. </summary>
        public static bool operator ==(RunStepType left, RunStepType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RunStepType"/> values are not the same. </summary>
        public static bool operator !=(RunStepType left, RunStepType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RunStepType"/>. </summary>
        public static implicit operator RunStepType(string value) => new RunStepType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RunStepType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RunStepType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
