// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> Possible values for the status of a run step. </summary>
    public readonly partial struct RunStepStatus : IEquatable<RunStepStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RunStepStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RunStepStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InProgressValue = "in_progress";
        private const string CancelledValue = "cancelled";
        private const string FailedValue = "failed";
        private const string CompletedValue = "completed";
        private const string ExpiredValue = "expired";

        /// <summary> Represents a run step still in progress. </summary>
        public static RunStepStatus InProgress { get; } = new RunStepStatus(InProgressValue);
        /// <summary> Represents a run step that was cancelled. </summary>
        public static RunStepStatus Cancelled { get; } = new RunStepStatus(CancelledValue);
        /// <summary> Represents a run step that failed. </summary>
        public static RunStepStatus Failed { get; } = new RunStepStatus(FailedValue);
        /// <summary> Represents a run step that successfully completed. </summary>
        public static RunStepStatus Completed { get; } = new RunStepStatus(CompletedValue);
        /// <summary> Represents a run step that expired before otherwise finishing. </summary>
        public static RunStepStatus Expired { get; } = new RunStepStatus(ExpiredValue);
        /// <summary> Determines if two <see cref="RunStepStatus"/> values are the same. </summary>
        public static bool operator ==(RunStepStatus left, RunStepStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RunStepStatus"/> values are not the same. </summary>
        public static bool operator !=(RunStepStatus left, RunStepStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RunStepStatus"/>. </summary>
        public static implicit operator RunStepStatus(string value) => new RunStepStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RunStepStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RunStepStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
