// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary>
    /// A record of a call to a retrieval tool, issued by the model in evaluation of a defined tool, that represents
    /// executed retrieval actions.
    /// </summary>
    public partial class RunStepRetrievalToolCall : RunStepToolCall
    {
        /// <summary> Initializes a new instance of <see cref="RunStepRetrievalToolCall"/>. </summary>
        /// <param name="id"> The ID of the tool call. This ID must be referenced when you submit tool outputs. </param>
        /// <param name="retrieval"> The key/value pairs produced by the retrieval tool. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="retrieval"/> is null. </exception>
        internal RunStepRetrievalToolCall(string id, IReadOnlyDictionary<string, string> retrieval) : base(id)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(retrieval, nameof(retrieval));

            Type = "retrieval";
            Retrieval = retrieval;
        }

        /// <summary> Initializes a new instance of <see cref="RunStepRetrievalToolCall"/>. </summary>
        /// <param name="type"> The object type. </param>
        /// <param name="id"> The ID of the tool call. This ID must be referenced when you submit tool outputs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="retrieval"> The key/value pairs produced by the retrieval tool. </param>
        internal RunStepRetrievalToolCall(string type, string id, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyDictionary<string, string> retrieval) : base(type, id, serializedAdditionalRawData)
        {
            Retrieval = retrieval;
        }

        /// <summary> Initializes a new instance of <see cref="RunStepRetrievalToolCall"/> for deserialization. </summary>
        internal RunStepRetrievalToolCall()
        {
        }

        /// <summary> The key/value pairs produced by the retrieval tool. </summary>
        public IReadOnlyDictionary<string, string> Retrieval { get; }
    }
}
