// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The detailed information associated with a message creation run step. </summary>
    public partial class RunStepMessageCreationDetails : RunStepDetails
    {
        /// <summary> Initializes a new instance of <see cref="RunStepMessageCreationDetails"/>. </summary>
        /// <param name="messageCreation"> Information about the message creation associated with this run step. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="messageCreation"/> is null. </exception>
        internal RunStepMessageCreationDetails(RunStepMessageCreationReference messageCreation)
        {
            Argument.AssertNotNull(messageCreation, nameof(messageCreation));

            Type = RunStepType.MessageCreation;
            MessageCreation = messageCreation;
        }

        /// <summary> Initializes a new instance of <see cref="RunStepMessageCreationDetails"/>. </summary>
        /// <param name="type"> The object type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="messageCreation"> Information about the message creation associated with this run step. </param>
        internal RunStepMessageCreationDetails(RunStepType type, IDictionary<string, BinaryData> serializedAdditionalRawData, RunStepMessageCreationReference messageCreation) : base(type, serializedAdditionalRawData)
        {
            MessageCreation = messageCreation;
        }

        /// <summary> Initializes a new instance of <see cref="RunStepMessageCreationDetails"/> for deserialization. </summary>
        internal RunStepMessageCreationDetails()
        {
        }

        /// <summary> Information about the message creation associated with this run step. </summary>
        public RunStepMessageCreationReference MessageCreation { get; }
    }
}
