// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> A representation of a log output emitted by a code interpreter tool in response to a tool call by the model. </summary>
    public partial class RunStepCodeInterpreterLogOutput : RunStepCodeInterpreterToolCallOutput
    {
        /// <summary> Initializes a new instance of <see cref="RunStepCodeInterpreterLogOutput"/>. </summary>
        /// <param name="logs"> The serialized log output emitted by the code interpreter. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="logs"/> is null. </exception>
        internal RunStepCodeInterpreterLogOutput(string logs)
        {
            Argument.AssertNotNull(logs, nameof(logs));

            Type = "logs";
            Logs = logs;
        }

        /// <summary> Initializes a new instance of <see cref="RunStepCodeInterpreterLogOutput"/>. </summary>
        /// <param name="type"> The object type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="logs"> The serialized log output emitted by the code interpreter. </param>
        internal RunStepCodeInterpreterLogOutput(string type, IDictionary<string, BinaryData> serializedAdditionalRawData, string logs) : base(type, serializedAdditionalRawData)
        {
            Logs = logs;
        }

        /// <summary> Initializes a new instance of <see cref="RunStepCodeInterpreterLogOutput"/> for deserialization. </summary>
        internal RunStepCodeInterpreterLogOutput()
        {
        }

        /// <summary> The serialized log output emitted by the code interpreter. </summary>
        public string Logs { get; }
    }
}
