// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The OpenAIPageableListOfThreadRun_object. </summary>
    internal readonly partial struct OpenAIPageableListOfThreadRunObject : IEquatable<OpenAIPageableListOfThreadRunObject>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OpenAIPageableListOfThreadRunObject"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OpenAIPageableListOfThreadRunObject(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ListValue = "list";

        /// <summary> list. </summary>
        public static OpenAIPageableListOfThreadRunObject List { get; } = new OpenAIPageableListOfThreadRunObject(ListValue);
        /// <summary> Determines if two <see cref="OpenAIPageableListOfThreadRunObject"/> values are the same. </summary>
        public static bool operator ==(OpenAIPageableListOfThreadRunObject left, OpenAIPageableListOfThreadRunObject right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OpenAIPageableListOfThreadRunObject"/> values are not the same. </summary>
        public static bool operator !=(OpenAIPageableListOfThreadRunObject left, OpenAIPageableListOfThreadRunObject right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OpenAIPageableListOfThreadRunObject"/>. </summary>
        public static implicit operator OpenAIPageableListOfThreadRunObject(string value) => new OpenAIPageableListOfThreadRunObject(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OpenAIPageableListOfThreadRunObject other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OpenAIPageableListOfThreadRunObject other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
