// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The OpenAIPageableListOfMessageFile_object. </summary>
    internal readonly partial struct OpenAIPageableListOfMessageFileObject : IEquatable<OpenAIPageableListOfMessageFileObject>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OpenAIPageableListOfMessageFileObject"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OpenAIPageableListOfMessageFileObject(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ListValue = "list";

        /// <summary> list. </summary>
        public static OpenAIPageableListOfMessageFileObject List { get; } = new OpenAIPageableListOfMessageFileObject(ListValue);
        /// <summary> Determines if two <see cref="OpenAIPageableListOfMessageFileObject"/> values are the same. </summary>
        public static bool operator ==(OpenAIPageableListOfMessageFileObject left, OpenAIPageableListOfMessageFileObject right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OpenAIPageableListOfMessageFileObject"/> values are not the same. </summary>
        public static bool operator !=(OpenAIPageableListOfMessageFileObject left, OpenAIPageableListOfMessageFileObject right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OpenAIPageableListOfMessageFileObject"/>. </summary>
        public static implicit operator OpenAIPageableListOfMessageFileObject(string value) => new OpenAIPageableListOfMessageFileObject(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OpenAIPageableListOfMessageFileObject other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OpenAIPageableListOfMessageFileObject other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
