// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The OpenAIPageableListOfAssistant_object. </summary>
    internal readonly partial struct OpenAIPageableListOfAssistantObject : IEquatable<OpenAIPageableListOfAssistantObject>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OpenAIPageableListOfAssistantObject"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OpenAIPageableListOfAssistantObject(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ListValue = "list";

        /// <summary> list. </summary>
        public static OpenAIPageableListOfAssistantObject List { get; } = new OpenAIPageableListOfAssistantObject(ListValue);
        /// <summary> Determines if two <see cref="OpenAIPageableListOfAssistantObject"/> values are the same. </summary>
        public static bool operator ==(OpenAIPageableListOfAssistantObject left, OpenAIPageableListOfAssistantObject right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OpenAIPageableListOfAssistantObject"/> values are not the same. </summary>
        public static bool operator !=(OpenAIPageableListOfAssistantObject left, OpenAIPageableListOfAssistantObject right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OpenAIPageableListOfAssistantObject"/>. </summary>
        public static implicit operator OpenAIPageableListOfAssistantObject(string value) => new OpenAIPageableListOfAssistantObject(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OpenAIPageableListOfAssistantObject other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OpenAIPageableListOfAssistantObject other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
