// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The possible values denoting the intended usage of a file. </summary>
    public readonly partial struct OpenAIFilePurpose : IEquatable<OpenAIFilePurpose>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OpenAIFilePurpose"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OpenAIFilePurpose(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FineTuneValue = "fine-tune";
        private const string FineTuneResultsValue = "fine-tune-results";
        private const string AssistantsValue = "assistants";
        private const string AssistantsOutputValue = "assistants_output";

        /// <summary> Indicates a file is used for fine tuning input. </summary>
        public static OpenAIFilePurpose FineTune { get; } = new OpenAIFilePurpose(FineTuneValue);
        /// <summary> Indicates a file is used for fine tuning results. </summary>
        public static OpenAIFilePurpose FineTuneResults { get; } = new OpenAIFilePurpose(FineTuneResultsValue);
        /// <summary> Indicates a file is used as input to assistants. </summary>
        public static OpenAIFilePurpose Assistants { get; } = new OpenAIFilePurpose(AssistantsValue);
        /// <summary> Indicates a file is used as output by assistants. </summary>
        public static OpenAIFilePurpose AssistantsOutput { get; } = new OpenAIFilePurpose(AssistantsOutputValue);
        /// <summary> Determines if two <see cref="OpenAIFilePurpose"/> values are the same. </summary>
        public static bool operator ==(OpenAIFilePurpose left, OpenAIFilePurpose right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OpenAIFilePurpose"/> values are not the same. </summary>
        public static bool operator !=(OpenAIFilePurpose left, OpenAIFilePurpose right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OpenAIFilePurpose"/>. </summary>
        public static implicit operator OpenAIFilePurpose(string value) => new OpenAIFilePurpose(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OpenAIFilePurpose other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OpenAIFilePurpose other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
