// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The possible values for roles attributed to messages in a thread. </summary>
    public readonly partial struct MessageRole : IEquatable<MessageRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MessageRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MessageRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserValue = "user";
        private const string AssistantValue = "assistant";

        /// <summary> The role representing the end-user. </summary>
        public static MessageRole User { get; } = new MessageRole(UserValue);
        /// <summary> The role representing the assistant. </summary>
        public static MessageRole Assistant { get; } = new MessageRole(AssistantValue);
        /// <summary> Determines if two <see cref="MessageRole"/> values are the same. </summary>
        public static bool operator ==(MessageRole left, MessageRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MessageRole"/> values are not the same. </summary>
        public static bool operator !=(MessageRole left, MessageRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MessageRole"/>. </summary>
        public static implicit operator MessageRole(string value) => new MessageRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MessageRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MessageRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
