// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The available sorting options when requesting a list of response objects. </summary>
    public readonly partial struct ListSortOrder : IEquatable<ListSortOrder>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ListSortOrder"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ListSortOrder(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AscendingValue = "asc";
        private const string DescendingValue = "desc";

        /// <summary> Specifies an ascending sort order. </summary>
        public static ListSortOrder Ascending { get; } = new ListSortOrder(AscendingValue);
        /// <summary> Specifies a descending sort order. </summary>
        public static ListSortOrder Descending { get; } = new ListSortOrder(DescendingValue);
        /// <summary> Determines if two <see cref="ListSortOrder"/> values are the same. </summary>
        public static bool operator ==(ListSortOrder left, ListSortOrder right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ListSortOrder"/> values are not the same. </summary>
        public static bool operator !=(ListSortOrder left, ListSortOrder right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ListSortOrder"/>. </summary>
        public static implicit operator ListSortOrder(string value) => new ListSortOrder(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ListSortOrder other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ListSortOrder other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
