// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The details describing tools that should be called to submit tool outputs. </summary>
    internal partial class InternalSubmitToolOutputsDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InternalSubmitToolOutputsDetails"/>. </summary>
        /// <param name="toolCalls">
        /// The list of tool calls that must be resolved for the assistant thread run to continue.
        /// Please note <see cref="RequiredToolCall"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RequiredFunctionToolCall"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="toolCalls"/> is null. </exception>
        internal InternalSubmitToolOutputsDetails(IEnumerable<RequiredToolCall> toolCalls)
        {
            Argument.AssertNotNull(toolCalls, nameof(toolCalls));

            ToolCalls = toolCalls.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="InternalSubmitToolOutputsDetails"/>. </summary>
        /// <param name="toolCalls">
        /// The list of tool calls that must be resolved for the assistant thread run to continue.
        /// Please note <see cref="RequiredToolCall"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RequiredFunctionToolCall"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InternalSubmitToolOutputsDetails(IReadOnlyList<RequiredToolCall> toolCalls, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ToolCalls = toolCalls;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="InternalSubmitToolOutputsDetails"/> for deserialization. </summary>
        internal InternalSubmitToolOutputsDetails()
        {
        }

        /// <summary>
        /// The list of tool calls that must be resolved for the assistant thread run to continue.
        /// Please note <see cref="RequiredToolCall"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RequiredFunctionToolCall"/>.
        /// </summary>
        public IReadOnlyList<RequiredToolCall> ToolCalls { get; }
    }
}
