// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> A representation of a file-based text citation, as used in a file-based annotation of text thread message content. </summary>
    internal partial class InternalMessageTextFileCitationDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InternalMessageTextFileCitationDetails"/>. </summary>
        /// <param name="fileId"> The ID of the file associated with this citation. </param>
        /// <param name="quote"> The specific quote cited in the associated file. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="fileId"/> or <paramref name="quote"/> is null. </exception>
        internal InternalMessageTextFileCitationDetails(string fileId, string quote)
        {
            Argument.AssertNotNull(fileId, nameof(fileId));
            Argument.AssertNotNull(quote, nameof(quote));

            FileId = fileId;
            Quote = quote;
        }

        /// <summary> Initializes a new instance of <see cref="InternalMessageTextFileCitationDetails"/>. </summary>
        /// <param name="fileId"> The ID of the file associated with this citation. </param>
        /// <param name="quote"> The specific quote cited in the associated file. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InternalMessageTextFileCitationDetails(string fileId, string quote, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FileId = fileId;
            Quote = quote;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="InternalMessageTextFileCitationDetails"/> for deserialization. </summary>
        internal InternalMessageTextFileCitationDetails()
        {
        }

        /// <summary> The ID of the file associated with this citation. </summary>
        public string FileId { get; }
        /// <summary> The specific quote cited in the associated file. </summary>
        public string Quote { get; }
    }
}
