// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> An image reference, as represented in thread message content. </summary>
    internal partial class InternalMessageImageFileDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InternalMessageImageFileDetails"/>. </summary>
        /// <param name="internalDetails"> The ID for the file associated with this image. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="internalDetails"/> is null. </exception>
        internal InternalMessageImageFileDetails(string internalDetails)
        {
            Argument.AssertNotNull(internalDetails, nameof(internalDetails));

            InternalDetails = internalDetails;
        }

        /// <summary> Initializes a new instance of <see cref="InternalMessageImageFileDetails"/>. </summary>
        /// <param name="internalDetails"> The ID for the file associated with this image. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InternalMessageImageFileDetails(string internalDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InternalDetails = internalDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="InternalMessageImageFileDetails"/> for deserialization. </summary>
        internal InternalMessageImageFileDetails()
        {
        }

        /// <summary> The ID for the file associated with this image. </summary>
        public string InternalDetails { get; }
    }
}
