// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> The InternalFileListResponse_object. </summary>
    internal readonly partial struct InternalFileListResponseObject : IEquatable<InternalFileListResponseObject>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InternalFileListResponseObject"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InternalFileListResponseObject(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ListValue = "list";

        /// <summary> list. </summary>
        public static InternalFileListResponseObject List { get; } = new InternalFileListResponseObject(ListValue);
        /// <summary> Determines if two <see cref="InternalFileListResponseObject"/> values are the same. </summary>
        public static bool operator ==(InternalFileListResponseObject left, InternalFileListResponseObject right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InternalFileListResponseObject"/> values are not the same. </summary>
        public static bool operator !=(InternalFileListResponseObject left, InternalFileListResponseObject right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InternalFileListResponseObject"/>. </summary>
        public static implicit operator InternalFileListResponseObject(string value) => new InternalFileListResponseObject(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InternalFileListResponseObject other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InternalFileListResponseObject other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
