// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.AI.OpenAI.Assistants
{
    /// <summary> Client options for AssistantsClient. </summary>
    public partial class AssistantsClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V2024_02_15_Preview;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2024-02-15-preview". </summary>
            V2024_02_15_Preview = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of AssistantsClientOptions. </summary>
        public AssistantsClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V2024_02_15_Preview => "2024-02-15-preview",
                _ => throw new NotSupportedException()
            };
        }
    }
}
