// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure;
using Azure.AI.OpenAI.Assistants;
using Azure.Core.Extensions;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="AssistantsClient"/> to client builder. </summary>
    public static partial class AIOpenAIAssistantsClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="AssistantsClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> An OpenAI endpoint supporting assistants functionality. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        public static IAzureClientBuilder<AssistantsClient, AssistantsClientOptions> AddAssistantsClient<TBuilder>(this TBuilder builder, Uri endpoint, AzureKeyCredential credential)
        where TBuilder : IAzureClientFactoryBuilder
        {
            return builder.RegisterClientFactory<AssistantsClient, AssistantsClientOptions>((options) => new AssistantsClient(endpoint, credential, options));
        }

        /// <summary> Registers a <see cref="AssistantsClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> An OpenAI endpoint supporting assistants functionality. </param>
        public static IAzureClientBuilder<AssistantsClient, AssistantsClientOptions> AddAssistantsClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<AssistantsClient, AssistantsClientOptions>((options, cred) => new AssistantsClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="AssistantsClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<AssistantsClient, AssistantsClientOptions> AddAssistantsClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<AssistantsClient, AssistantsClientOptions>(configuration);
        }
    }
}
