// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;
using Azure.MixedReality.Common;

namespace Azure.MixedReality.ObjectAnchors.Conversion.Models
{
    internal partial class Vector4 : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("x"u8);
            writer.WriteNumberValue(X);
            writer.WritePropertyName("y"u8);
            writer.WriteNumberValue(Y);
            writer.WritePropertyName("z"u8);
            writer.WriteNumberValue(Z);
            writer.WritePropertyName("w"u8);
            writer.WriteNumberValue(W);
            writer.WriteEndObject();
        }

        internal static Vector4 DeserializeVector4(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            float x = default;
            float y = default;
            float z = default;
            float w = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("x"u8))
                {
                    x = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("y"u8))
                {
                    y = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("z"u8))
                {
                    z = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("w"u8))
                {
                    w = property.Value.GetSingle();
                    continue;
                }
            }
            return new Vector4(x, y, z, w);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static Vector4 FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeVector4(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
