// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.MixedReality.Common;

namespace Azure.MixedReality.ObjectAnchors.Conversion.Models
{
    /// <summary> Represents an error. </summary>
    internal partial class ErrorDetail
    {
        /// <summary> Initializes a new instance of <see cref="ErrorDetail"/>. </summary>
        /// <param name="code"> The error code. </param>
        /// <param name="message"> The error message. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="code"/> or <paramref name="message"/> is null. </exception>
        internal ErrorDetail(string code, string message)
        {
            Argument.AssertNotNull(code, nameof(code));
            Argument.AssertNotNull(message, nameof(message));

            Code = code;
            Message = message;
            Details = new ChangeTrackingList<ErrorDetail>();
        }

        /// <summary> Initializes a new instance of <see cref="ErrorDetail"/>. </summary>
        /// <param name="code"> The error code. </param>
        /// <param name="message"> The error message. </param>
        /// <param name="target"> The target of the error. </param>
        /// <param name="details"></param>
        /// <param name="innererror"> An object containing more specific information than the current object about the error. </param>
        internal ErrorDetail(string code, string message, string target, IReadOnlyList<ErrorDetail> details, InnerError innererror)
        {
            Code = code;
            Message = message;
            Target = target;
            Details = details;
            Innererror = innererror;
        }

        /// <summary> The error code. </summary>
        public string Code { get; }
        /// <summary> The error message. </summary>
        public string Message { get; }
        /// <summary> The target of the error. </summary>
        public string Target { get; }
        /// <summary> Gets the details. </summary>
        public IReadOnlyList<ErrorDetail> Details { get; }
        /// <summary> An object containing more specific information than the current object about the error. </summary>
        public InnerError Innererror { get; }
    }
}
