// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.MixedReality.ObjectAnchors.Conversion
{
    /// <summary> The asset conversion error code. </summary>
    public readonly partial struct ConversionErrorCode : IEquatable<ConversionErrorCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConversionErrorCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConversionErrorCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "UNKNOWN";
        private const string NoErrorValue = "NO_ERROR";
        private const string ServiceErrorValue = "SERVICE_ERROR";
        private const string InvalidAssetUriValue = "INVALID_ASSET_URI";
        private const string InvalidJobIdValue = "INVALID_JOB_ID";
        private const string InvalidGravityValue = "INVALID_GRAVITY";
        private const string InvalidScaleValue = "INVALID_SCALE";
        private const string AssetSizeTooLargeValue = "ASSET_SIZE_TOO_LARGE";
        private const string AssetDimensionsOutOfBoundsValue = "ASSET_DIMENSIONS_OUT_OF_BOUNDS";
        private const string ZeroFacesValue = "ZERO_FACES";
        private const string InvalidFaceVerticesValue = "INVALID_FACE_VERTICES";
        private const string ZeroTrajectoriesGeneratedValue = "ZERO_TRAJECTORIES_GENERATED";
        private const string TooManyRigPosesValue = "TOO_MANY_RIG_POSES";
        private const string AssetCannotBeConvertedValue = "ASSET_CANNOT_BE_CONVERTED";

        /// <summary> Unknown. </summary>
        public static ConversionErrorCode Unknown { get; } = new ConversionErrorCode(UnknownValue);
        /// <summary> No error. </summary>
        public static ConversionErrorCode NoError { get; } = new ConversionErrorCode(NoErrorValue);
        /// <summary> An unknown service error occurred. </summary>
        public static ConversionErrorCode ServiceError { get; } = new ConversionErrorCode(ServiceErrorValue);
        /// <summary> The asset at the URI provided when starting the conversion job could not be found. </summary>
        public static ConversionErrorCode InvalidAssetUri { get; } = new ConversionErrorCode(InvalidAssetUriValue);
        /// <summary> The provided ID for the asset conversion job to be created was set to the default all-zero GUID. </summary>
        public static ConversionErrorCode InvalidJobId { get; } = new ConversionErrorCode(InvalidJobIdValue);
        /// <summary> The gravity vector provided when creating the asset conversion job was a fully zeroed vector. </summary>
        public static ConversionErrorCode InvalidGravity { get; } = new ConversionErrorCode(InvalidGravityValue);
        /// <summary> The provided scale factor was not a positive non-zero value. </summary>
        public static ConversionErrorCode InvalidScale { get; } = new ConversionErrorCode(InvalidScaleValue);
        /// <summary> The intermediate .PLY file generated from the asset or its serialized equivalent was too large. </summary>
        public static ConversionErrorCode AssetSizeTooLarge { get; } = new ConversionErrorCode(AssetSizeTooLargeValue);
        /// <summary> The dimensions of the asset exceeded the physical dimension limit. This can be a sign of an improperly set scale for the asset when creating a job. </summary>
        public static ConversionErrorCode AssetDimensionsOutOfBounds { get; } = new ConversionErrorCode(AssetDimensionsOutOfBoundsValue);
        /// <summary> The intermediate .PLY file generated from the asset was determined to have no faces, making it invalid for conversion. </summary>
        public static ConversionErrorCode ZeroFaces { get; } = new ConversionErrorCode(ZeroFacesValue);
        /// <summary> The intermediate .PLY file generated from the asset contained faces that referenced nonexistent vertices. </summary>
        public static ConversionErrorCode InvalidFaceVertices { get; } = new ConversionErrorCode(InvalidFaceVerticesValue);
        /// <summary> The camera trajectories generated from the uploaded asset were empty. </summary>
        public static ConversionErrorCode ZeroTrajectoriesGenerated { get; } = new ConversionErrorCode(ZeroTrajectoriesGeneratedValue);
        /// <summary> The number of rig poses in the intermediate .PLY asset file exceeded service limits. </summary>
        public static ConversionErrorCode TooManyRigPoses { get; } = new ConversionErrorCode(TooManyRigPosesValue);
        /// <summary> The provided asset was corrupted, malformed, or otherwise unable to be converted in its provided format. </summary>
        public static ConversionErrorCode AssetCannotBeConverted { get; } = new ConversionErrorCode(AssetCannotBeConvertedValue);
        /// <summary> Determines if two <see cref="ConversionErrorCode"/> values are the same. </summary>
        public static bool operator ==(ConversionErrorCode left, ConversionErrorCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConversionErrorCode"/> values are not the same. </summary>
        public static bool operator !=(ConversionErrorCode left, ConversionErrorCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConversionErrorCode"/>. </summary>
        public static implicit operator ConversionErrorCode(string value) => new ConversionErrorCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConversionErrorCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConversionErrorCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
