// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.MixedReality.ObjectAnchors.Conversion
{
    internal static partial class AssetConversionStatusExtensions
    {
        public static string ToSerialString(this AssetConversionStatus value) => value switch
        {
            AssetConversionStatus.NotStarted => "NotStarted",
            AssetConversionStatus.Running => "Running",
            AssetConversionStatus.Succeeded => "Succeeded",
            AssetConversionStatus.Failed => "Failed",
            AssetConversionStatus.Cancelled => "Cancelled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AssetConversionStatus value.")
        };

        public static AssetConversionStatus ToAssetConversionStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotStarted")) return AssetConversionStatus.NotStarted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Running")) return AssetConversionStatus.Running;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return AssetConversionStatus.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return AssetConversionStatus.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Cancelled")) return AssetConversionStatus.Cancelled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AssetConversionStatus value.");
        }
    }
}
