// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Core;
using Azure.MixedReality.Common;
using Azure.MixedReality.ObjectAnchors.Conversion.Models;

namespace Azure.MixedReality.ObjectAnchors.Conversion
{
    public partial class AssetConversionProperties : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Common.Optional.IsDefined(ConversionStatus))
            {
                writer.WritePropertyName("jobStatus"u8);
                writer.WriteStringValue(ConversionStatus.Value.ToSerialString());
            }
            if (Common.Optional.IsDefined(AssetFileTypeString))
            {
                writer.WritePropertyName("assetFileType"u8);
                writer.WriteStringValue(AssetFileTypeString);
            }
            if (Common.Optional.IsDefined(InputAssetUriString))
            {
                writer.WritePropertyName("inputAssetUri"u8);
                writer.WriteStringValue(InputAssetUriString);
            }
            if (Common.Optional.IsDefined(ConversionConfiguration))
            {
                writer.WritePropertyName("ingestionConfiguration"u8);
                writer.WriteObjectValue<AssetConversionConfiguration>(ConversionConfiguration);
            }
            writer.WriteEndObject();
        }

        internal static AssetConversionProperties DeserializeAssetConversionProperties(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string clientErrorDetails = default;
            string serverErrorDetails = default;
            ConversionErrorCode errorCode = default;
            Guid? jobId = default;
            string outputModelUri = default;
            AssetConversionStatus? jobStatus = default;
            string assetFileType = default;
            string inputAssetUri = default;
            Guid? accountId = default;
            AssetConversionConfiguration ingestionConfiguration = default;
            Vector3 scaledAssetDimensions = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("clientErrorDetails"u8))
                {
                    clientErrorDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serverErrorDetails"u8))
                {
                    serverErrorDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("errorCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    errorCode = new ConversionErrorCode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("jobId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    jobId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("outputModelUri"u8))
                {
                    outputModelUri = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("jobStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    jobStatus = property.Value.GetString().ToAssetConversionStatus();
                    continue;
                }
                if (property.NameEquals("assetFileType"u8))
                {
                    assetFileType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("inputAssetUri"u8))
                {
                    inputAssetUri = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("accountId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    accountId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("ingestionConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ingestionConfiguration = AssetConversionConfiguration.DeserializeAssetConversionConfiguration(property.Value);
                    continue;
                }
                if (property.NameEquals("scaledAssetDimensions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        scaledAssetDimensions = null;
                        continue;
                    }
                    scaledAssetDimensions = Vector3.DeserializeVector3(property.Value);
                    continue;
                }
            }
            return new AssetConversionProperties(
                clientErrorDetails,
                serverErrorDetails,
                errorCode,
                jobId,
                outputModelUri,
                jobStatus,
                assetFileType,
                inputAssetUri,
                accountId,
                ingestionConfiguration,
                scaledAssetDimensions);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AssetConversionProperties FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAssetConversionProperties(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
