// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.MixedReality.Common;
using Azure.MixedReality.ObjectAnchors.Conversion.Models;

namespace Azure.MixedReality.ObjectAnchors.Conversion
{
    /// <summary> Represents an ingestion configuration. </summary>
    public partial class AssetConversionConfiguration
    {
        /// <summary> Initializes a new instance of <see cref="AssetConversionConfiguration"/>. </summary>
        /// <param name="assetDimensionsWrapper"> Dimensions of the asset. </param>
        /// <param name="boundingBoxCenterWrapper"> BoundingBoxCenter of the asset. </param>
        /// <param name="gravityWrapper"> Gravity vector with respect to object's nominal position. </param>
        /// <param name="keyFrameIndexes"> Indices of Key Frames. </param>
        /// <param name="groundTruthTrajectoryCameraPoses"> Ground truth trajectory. </param>
        /// <param name="principalAxisWrapper"> Orientation of model's bounding box. </param>
        /// <param name="scale"> Scale of transformation of asset units into meter space. </param>
        /// <param name="disableDetectScaleUnits"> Whether or not disable the scale units in the model metadata. </param>
        /// <param name="supportingPlaneWrapper"> Definition of supporting plane. </param>
        /// <param name="testTrajectoryCameraPoses"> Test Trajectory. </param>
        internal AssetConversionConfiguration(Vector3 assetDimensionsWrapper, Vector3 boundingBoxCenterWrapper, Vector3 gravityWrapper, IReadOnlyList<int> keyFrameIndexes, IReadOnlyList<TrajectoryPose> groundTruthTrajectoryCameraPoses, Quaternion principalAxisWrapper, float scale, bool disableDetectScaleUnits, Vector4 supportingPlaneWrapper, IReadOnlyList<TrajectoryPose> testTrajectoryCameraPoses)
        {
            AssetDimensionsWrapper = assetDimensionsWrapper;
            BoundingBoxCenterWrapper = boundingBoxCenterWrapper;
            GravityWrapper = gravityWrapper;
            KeyFrameIndexes = keyFrameIndexes;
            GroundTruthTrajectoryCameraPoses = groundTruthTrajectoryCameraPoses;
            PrincipalAxisWrapper = principalAxisWrapper;
            Scale = scale;
            DisableDetectScaleUnits = disableDetectScaleUnits;
            SupportingPlaneWrapper = supportingPlaneWrapper;
            TestTrajectoryCameraPoses = testTrajectoryCameraPoses;
        }
    }
}
