﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

namespace Azure.MixedReality.ObjectAnchors.Conversion
{
    /// <summary>
    /// Represents the measurement of a single distance unit in an asset.
    /// </summary>
    public enum AssetLengthUnit
    {
        /// <summary>
        /// Meters.
        /// </summary>
        Meters = 0,

        /// <summary>
        /// Centimeters.
        /// </summary>
        Centimeters = 1,

        /// <summary>
        /// Decimeters.
        /// </summary>
        Decimeters = 2,

        /// <summary>
        /// Feet.
        /// </summary>
        Feet = 3,

        /// <summary>
        /// Inches.
        /// </summary>
        Inches = 4,

        /// <summary>
        /// Kilometers.
        /// </summary>
        Kilometers = 5,

        /// <summary>
        /// Millimeters.
        /// </summary>
        Millimeters = 6,

        /// <summary>
        /// Yards.
        /// </summary>
        Yards = 7
    }
}
