// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.NotificationHubs
{
    /// <summary>
    /// A class representing a collection of <see cref="NotificationHubsPrivateLinkResource"/> and their operations.
    /// Each <see cref="NotificationHubsPrivateLinkResource"/> in the collection will belong to the same instance of <see cref="NotificationHubNamespaceResource"/>.
    /// To get a <see cref="NotificationHubsPrivateLinkResourceCollection"/> instance call the GetNotificationHubsPrivateLinkResources method from an instance of <see cref="NotificationHubNamespaceResource"/>.
    /// </summary>
    public partial class NotificationHubsPrivateLinkResourceCollection : ArmCollection, IEnumerable<NotificationHubsPrivateLinkResource>, IAsyncEnumerable<NotificationHubsPrivateLinkResource>
    {
        private readonly ClientDiagnostics _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsClientDiagnostics;
        private readonly PrivateEndpointConnectionsRestOperations _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsRestClient;

        /// <summary> Initializes a new instance of the <see cref="NotificationHubsPrivateLinkResourceCollection"/> class for mocking. </summary>
        protected NotificationHubsPrivateLinkResourceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="NotificationHubsPrivateLinkResourceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal NotificationHubsPrivateLinkResourceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.NotificationHubs", NotificationHubsPrivateLinkResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(NotificationHubsPrivateLinkResource.ResourceType, out string notificationHubsPrivateLinkResourcePrivateEndpointConnectionsApiVersion);
            _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsRestClient = new PrivateEndpointConnectionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, notificationHubsPrivateLinkResourcePrivateEndpointConnectionsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != NotificationHubNamespaceResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, NotificationHubNamespaceResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Even though this namespace requires subscription id, resource group and namespace name, it returns a constant payload (for a given namespacE) every time it's called.
        /// That's why we don't send it to the sibling RP, but process it directly in the scale unit that received the request.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/privateLinkResources/{subResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateEndpointConnections_GetGroupId</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NotificationHubsPrivateLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="subResourceName"> Name of the Private Link sub-resource. The only supported sub-resource is "namespace". </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="subResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="subResourceName"/> is null. </exception>
        public virtual async Task<Response<NotificationHubsPrivateLinkResource>> GetAsync(string subResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subResourceName, nameof(subResourceName));

            using var scope = _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsClientDiagnostics.CreateScope("NotificationHubsPrivateLinkResourceCollection.Get");
            scope.Start();
            try
            {
                var response = await _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsRestClient.GetGroupIdAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, subResourceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new NotificationHubsPrivateLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Even though this namespace requires subscription id, resource group and namespace name, it returns a constant payload (for a given namespacE) every time it's called.
        /// That's why we don't send it to the sibling RP, but process it directly in the scale unit that received the request.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/privateLinkResources/{subResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateEndpointConnections_GetGroupId</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NotificationHubsPrivateLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="subResourceName"> Name of the Private Link sub-resource. The only supported sub-resource is "namespace". </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="subResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="subResourceName"/> is null. </exception>
        public virtual Response<NotificationHubsPrivateLinkResource> Get(string subResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subResourceName, nameof(subResourceName));

            using var scope = _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsClientDiagnostics.CreateScope("NotificationHubsPrivateLinkResourceCollection.Get");
            scope.Start();
            try
            {
                var response = _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsRestClient.GetGroupId(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, subResourceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new NotificationHubsPrivateLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Even though this namespace requires subscription id, resource group and namespace name, it returns a constant payload (for a given namespacE) every time it's called.
        /// That's why we don't send it to the sibling RP, but process it directly in the scale unit that received the request.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/privateLinkResources</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateEndpointConnections_ListGroupIds</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NotificationHubsPrivateLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="NotificationHubsPrivateLinkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<NotificationHubsPrivateLinkResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsRestClient.CreateListGroupIdsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => new NotificationHubsPrivateLinkResource(Client, NotificationHubsPrivateLinkResourceData.DeserializeNotificationHubsPrivateLinkResourceData(e)), _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsClientDiagnostics, Pipeline, "NotificationHubsPrivateLinkResourceCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Even though this namespace requires subscription id, resource group and namespace name, it returns a constant payload (for a given namespacE) every time it's called.
        /// That's why we don't send it to the sibling RP, but process it directly in the scale unit that received the request.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/privateLinkResources</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateEndpointConnections_ListGroupIds</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NotificationHubsPrivateLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="NotificationHubsPrivateLinkResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<NotificationHubsPrivateLinkResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsRestClient.CreateListGroupIdsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => new NotificationHubsPrivateLinkResource(Client, NotificationHubsPrivateLinkResourceData.DeserializeNotificationHubsPrivateLinkResourceData(e)), _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsClientDiagnostics, Pipeline, "NotificationHubsPrivateLinkResourceCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/privateLinkResources/{subResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateEndpointConnections_GetGroupId</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NotificationHubsPrivateLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="subResourceName"> Name of the Private Link sub-resource. The only supported sub-resource is "namespace". </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="subResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="subResourceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string subResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subResourceName, nameof(subResourceName));

            using var scope = _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsClientDiagnostics.CreateScope("NotificationHubsPrivateLinkResourceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsRestClient.GetGroupIdAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, subResourceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/privateLinkResources/{subResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateEndpointConnections_GetGroupId</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NotificationHubsPrivateLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="subResourceName"> Name of the Private Link sub-resource. The only supported sub-resource is "namespace". </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="subResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="subResourceName"/> is null. </exception>
        public virtual Response<bool> Exists(string subResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subResourceName, nameof(subResourceName));

            using var scope = _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsClientDiagnostics.CreateScope("NotificationHubsPrivateLinkResourceCollection.Exists");
            scope.Start();
            try
            {
                var response = _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsRestClient.GetGroupId(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, subResourceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/privateLinkResources/{subResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateEndpointConnections_GetGroupId</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NotificationHubsPrivateLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="subResourceName"> Name of the Private Link sub-resource. The only supported sub-resource is "namespace". </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="subResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="subResourceName"/> is null. </exception>
        public virtual async Task<NullableResponse<NotificationHubsPrivateLinkResource>> GetIfExistsAsync(string subResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subResourceName, nameof(subResourceName));

            using var scope = _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsClientDiagnostics.CreateScope("NotificationHubsPrivateLinkResourceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsRestClient.GetGroupIdAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, subResourceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<NotificationHubsPrivateLinkResource>(response.GetRawResponse());
                return Response.FromValue(new NotificationHubsPrivateLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/privateLinkResources/{subResourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateEndpointConnections_GetGroupId</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="NotificationHubsPrivateLinkResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="subResourceName"> Name of the Private Link sub-resource. The only supported sub-resource is "namespace". </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="subResourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="subResourceName"/> is null. </exception>
        public virtual NullableResponse<NotificationHubsPrivateLinkResource> GetIfExists(string subResourceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subResourceName, nameof(subResourceName));

            using var scope = _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsClientDiagnostics.CreateScope("NotificationHubsPrivateLinkResourceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _notificationHubsPrivateLinkResourcePrivateEndpointConnectionsRestClient.GetGroupId(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, subResourceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<NotificationHubsPrivateLinkResource>(response.GetRawResponse());
                return Response.FromValue(new NotificationHubsPrivateLinkResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<NotificationHubsPrivateLinkResource> IEnumerable<NotificationHubsPrivateLinkResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<NotificationHubsPrivateLinkResource> IAsyncEnumerable<NotificationHubsPrivateLinkResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
