// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Namespace SKU name. </summary>
    public readonly partial struct ZoneRedundancyPreference : IEquatable<ZoneRedundancyPreference>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ZoneRedundancyPreference"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ZoneRedundancyPreference(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static ZoneRedundancyPreference Disabled { get; } = new ZoneRedundancyPreference(DisabledValue);
        /// <summary> Enabled. </summary>
        public static ZoneRedundancyPreference Enabled { get; } = new ZoneRedundancyPreference(EnabledValue);
        /// <summary> Determines if two <see cref="ZoneRedundancyPreference"/> values are the same. </summary>
        public static bool operator ==(ZoneRedundancyPreference left, ZoneRedundancyPreference right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ZoneRedundancyPreference"/> values are not the same. </summary>
        public static bool operator !=(ZoneRedundancyPreference left, ZoneRedundancyPreference right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ZoneRedundancyPreference"/>. </summary>
        public static implicit operator ZoneRedundancyPreference(string value) => new ZoneRedundancyPreference(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ZoneRedundancyPreference other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ZoneRedundancyPreference other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
