// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    public partial class PnsCredentials : IUtf8JsonSerializable, IJsonModel<PnsCredentials>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PnsCredentials>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PnsCredentials>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PnsCredentials>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PnsCredentials)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AdmCredential))
            {
                writer.WritePropertyName("admCredential"u8);
                writer.WriteObjectValue(AdmCredential, options);
            }
            if (Optional.IsDefined(ApnsCredential))
            {
                writer.WritePropertyName("apnsCredential"u8);
                writer.WriteObjectValue(ApnsCredential, options);
            }
            if (Optional.IsDefined(BaiduCredential))
            {
                writer.WritePropertyName("baiduCredential"u8);
                writer.WriteObjectValue(BaiduCredential, options);
            }
            if (Optional.IsDefined(BrowserCredential))
            {
                writer.WritePropertyName("browserCredential"u8);
                writer.WriteObjectValue(BrowserCredential, options);
            }
            if (Optional.IsDefined(GcmCredential))
            {
                writer.WritePropertyName("gcmCredential"u8);
                writer.WriteObjectValue(GcmCredential, options);
            }
            if (Optional.IsDefined(MpnsCredential))
            {
                writer.WritePropertyName("mpnsCredential"u8);
                writer.WriteObjectValue(MpnsCredential, options);
            }
            if (Optional.IsDefined(WnsCredential))
            {
                writer.WritePropertyName("wnsCredential"u8);
                writer.WriteObjectValue(WnsCredential, options);
            }
            if (Optional.IsDefined(XiaomiCredential))
            {
                writer.WritePropertyName("xiaomiCredential"u8);
                writer.WriteObjectValue(XiaomiCredential, options);
            }
            if (Optional.IsDefined(FcmV1Credential))
            {
                writer.WritePropertyName("fcmV1Credential"u8);
                writer.WriteObjectValue(FcmV1Credential, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PnsCredentials IJsonModel<PnsCredentials>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PnsCredentials>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PnsCredentials)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePnsCredentials(document.RootElement, options);
        }

        internal static PnsCredentials DeserializePnsCredentials(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            NotificationHubAdmCredential admCredential = default;
            NotificationHubApnsCredential apnsCredential = default;
            NotificationHubBaiduCredential baiduCredential = default;
            BrowserCredential browserCredential = default;
            NotificationHubGcmCredential gcmCredential = default;
            NotificationHubMpnsCredential mpnsCredential = default;
            NotificationHubWnsCredential wnsCredential = default;
            XiaomiCredential xiaomiCredential = default;
            FcmV1Credential fcmV1Credential = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("admCredential"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    admCredential = NotificationHubAdmCredential.DeserializeNotificationHubAdmCredential(property.Value, options);
                    continue;
                }
                if (property.NameEquals("apnsCredential"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    apnsCredential = NotificationHubApnsCredential.DeserializeNotificationHubApnsCredential(property.Value, options);
                    continue;
                }
                if (property.NameEquals("baiduCredential"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    baiduCredential = NotificationHubBaiduCredential.DeserializeNotificationHubBaiduCredential(property.Value, options);
                    continue;
                }
                if (property.NameEquals("browserCredential"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    browserCredential = BrowserCredential.DeserializeBrowserCredential(property.Value, options);
                    continue;
                }
                if (property.NameEquals("gcmCredential"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    gcmCredential = NotificationHubGcmCredential.DeserializeNotificationHubGcmCredential(property.Value, options);
                    continue;
                }
                if (property.NameEquals("mpnsCredential"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mpnsCredential = NotificationHubMpnsCredential.DeserializeNotificationHubMpnsCredential(property.Value, options);
                    continue;
                }
                if (property.NameEquals("wnsCredential"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wnsCredential = NotificationHubWnsCredential.DeserializeNotificationHubWnsCredential(property.Value, options);
                    continue;
                }
                if (property.NameEquals("xiaomiCredential"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    xiaomiCredential = XiaomiCredential.DeserializeXiaomiCredential(property.Value, options);
                    continue;
                }
                if (property.NameEquals("fcmV1Credential"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fcmV1Credential = FcmV1Credential.DeserializeFcmV1Credential(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PnsCredentials(
                admCredential,
                apnsCredential,
                baiduCredential,
                browserCredential,
                gcmCredential,
                mpnsCredential,
                wnsCredential,
                xiaomiCredential,
                fcmV1Credential,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PnsCredentials>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PnsCredentials>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PnsCredentials)} does not support writing '{options.Format}' format.");
            }
        }

        PnsCredentials IPersistableModel<PnsCredentials>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PnsCredentials>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePnsCredentials(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PnsCredentials)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PnsCredentials>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
