// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Defines values for OperationProvisioningState. </summary>
    public readonly partial struct OperationProvisioningState : IEquatable<OperationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string InProgressValue = "InProgress";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string PendingValue = "Pending";
        private const string DisabledValue = "Disabled";

        /// <summary> Unknown. </summary>
        public static OperationProvisioningState Unknown { get; } = new OperationProvisioningState(UnknownValue);
        /// <summary> InProgress. </summary>
        public static OperationProvisioningState InProgress { get; } = new OperationProvisioningState(InProgressValue);
        /// <summary> Succeeded. </summary>
        public static OperationProvisioningState Succeeded { get; } = new OperationProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static OperationProvisioningState Failed { get; } = new OperationProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static OperationProvisioningState Canceled { get; } = new OperationProvisioningState(CanceledValue);
        /// <summary> Pending. </summary>
        public static OperationProvisioningState Pending { get; } = new OperationProvisioningState(PendingValue);
        /// <summary> Disabled. </summary>
        public static OperationProvisioningState Disabled { get; } = new OperationProvisioningState(DisabledValue);
        /// <summary> Determines if two <see cref="OperationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(OperationProvisioningState left, OperationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(OperationProvisioningState left, OperationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationProvisioningState"/>. </summary>
        public static implicit operator OperationProvisioningState(string value) => new OperationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
