// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> State of Private Endpoint Connection. </summary>
    public readonly partial struct NotificationHubsPrivateEndpointConnectionProvisioningState : IEquatable<NotificationHubsPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NotificationHubsPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NotificationHubsPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string UpdatingByProxyValue = "UpdatingByProxy";
        private const string DeletingValue = "Deleting";
        private const string DeletingByProxyValue = "DeletingByProxy";
        private const string DeletedValue = "Deleted";

        /// <summary> Unknown. </summary>
        public static NotificationHubsPrivateEndpointConnectionProvisioningState Unknown { get; } = new NotificationHubsPrivateEndpointConnectionProvisioningState(UnknownValue);
        /// <summary> Succeeded. </summary>
        public static NotificationHubsPrivateEndpointConnectionProvisioningState Succeeded { get; } = new NotificationHubsPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static NotificationHubsPrivateEndpointConnectionProvisioningState Creating { get; } = new NotificationHubsPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static NotificationHubsPrivateEndpointConnectionProvisioningState Updating { get; } = new NotificationHubsPrivateEndpointConnectionProvisioningState(UpdatingValue);
        /// <summary> UpdatingByProxy. </summary>
        public static NotificationHubsPrivateEndpointConnectionProvisioningState UpdatingByProxy { get; } = new NotificationHubsPrivateEndpointConnectionProvisioningState(UpdatingByProxyValue);
        /// <summary> Deleting. </summary>
        public static NotificationHubsPrivateEndpointConnectionProvisioningState Deleting { get; } = new NotificationHubsPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> DeletingByProxy. </summary>
        public static NotificationHubsPrivateEndpointConnectionProvisioningState DeletingByProxy { get; } = new NotificationHubsPrivateEndpointConnectionProvisioningState(DeletingByProxyValue);
        /// <summary> Deleted. </summary>
        public static NotificationHubsPrivateEndpointConnectionProvisioningState Deleted { get; } = new NotificationHubsPrivateEndpointConnectionProvisioningState(DeletedValue);
        /// <summary> Determines if two <see cref="NotificationHubsPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(NotificationHubsPrivateEndpointConnectionProvisioningState left, NotificationHubsPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NotificationHubsPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(NotificationHubsPrivateEndpointConnectionProvisioningState left, NotificationHubsPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NotificationHubsPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator NotificationHubsPrivateEndpointConnectionProvisioningState(string value) => new NotificationHubsPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NotificationHubsPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NotificationHubsPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
