// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Description of a NotificationHub WnsCredential. </summary>
    public partial class NotificationHubWnsCredential
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotificationHubWnsCredential"/>. </summary>
        public NotificationHubWnsCredential()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NotificationHubWnsCredential"/>. </summary>
        /// <param name="packageSid"> Gets or sets the package ID for this credential. </param>
        /// <param name="secretKey"> Gets or sets the secret key. </param>
        /// <param name="windowsLiveEndpoint"> Gets or sets the Windows Live endpoint. </param>
        /// <param name="certificateKey"> Ges or sets the WNS Certificate Key. </param>
        /// <param name="wnsCertificate"> Gets or sets the WNS Certificate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotificationHubWnsCredential(string packageSid, string secretKey, Uri windowsLiveEndpoint, string certificateKey, string wnsCertificate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PackageSid = packageSid;
            SecretKey = secretKey;
            WindowsLiveEndpoint = windowsLiveEndpoint;
            CertificateKey = certificateKey;
            WnsCertificate = wnsCertificate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the package ID for this credential. </summary>
        public string PackageSid { get; set; }
        /// <summary> Gets or sets the secret key. </summary>
        public string SecretKey { get; set; }
        /// <summary> Gets or sets the Windows Live endpoint. </summary>
        public Uri WindowsLiveEndpoint { get; set; }
        /// <summary> Ges or sets the WNS Certificate Key. </summary>
        public string CertificateKey { get; set; }
        /// <summary> Gets or sets the WNS Certificate. </summary>
        public string WnsCertificate { get; set; }
    }
}
