// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Response for the POST request that returns Namespace or NotificationHub access keys (connection strings). </summary>
    public partial class NotificationHubResourceKeys
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotificationHubResourceKeys"/>. </summary>
        internal NotificationHubResourceKeys()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NotificationHubResourceKeys"/>. </summary>
        /// <param name="primaryConnectionString"> Gets or sets primaryConnectionString of the AuthorizationRule. </param>
        /// <param name="secondaryConnectionString">
        /// Gets or sets secondaryConnectionString of the created
        /// AuthorizationRule
        /// </param>
        /// <param name="primaryKey"> Gets or sets primaryKey of the created AuthorizationRule. </param>
        /// <param name="secondaryKey"> Gets or sets secondaryKey of the created AuthorizationRule. </param>
        /// <param name="keyName"> Gets or sets keyName of the created AuthorizationRule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotificationHubResourceKeys(string primaryConnectionString, string secondaryConnectionString, string primaryKey, string secondaryKey, string keyName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrimaryConnectionString = primaryConnectionString;
            SecondaryConnectionString = secondaryConnectionString;
            PrimaryKey = primaryKey;
            SecondaryKey = secondaryKey;
            KeyName = keyName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets primaryConnectionString of the AuthorizationRule. </summary>
        public string PrimaryConnectionString { get; }
        /// <summary>
        /// Gets or sets secondaryConnectionString of the created
        /// AuthorizationRule
        /// </summary>
        public string SecondaryConnectionString { get; }
        /// <summary> Gets or sets primaryKey of the created AuthorizationRule. </summary>
        public string PrimaryKey { get; }
        /// <summary> Gets or sets secondaryKey of the created AuthorizationRule. </summary>
        public string SecondaryKey { get; }
        /// <summary> Gets or sets keyName of the created AuthorizationRule. </summary>
        public string KeyName { get; }
    }
}
