// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Type of public network access. </summary>
    public readonly partial struct NotificationHubPublicNetworkAccess : IEquatable<NotificationHubPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NotificationHubPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NotificationHubPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static NotificationHubPublicNetworkAccess Enabled { get; } = new NotificationHubPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static NotificationHubPublicNetworkAccess Disabled { get; } = new NotificationHubPublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="NotificationHubPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(NotificationHubPublicNetworkAccess left, NotificationHubPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NotificationHubPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(NotificationHubPublicNetworkAccess left, NotificationHubPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NotificationHubPublicNetworkAccess"/>. </summary>
        public static implicit operator NotificationHubPublicNetworkAccess(string value) => new NotificationHubPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NotificationHubPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NotificationHubPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
