// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Notification result for a single registration. </summary>
    public partial class NotificationHubPubRegistrationResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotificationHubPubRegistrationResult"/>. </summary>
        internal NotificationHubPubRegistrationResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NotificationHubPubRegistrationResult"/>. </summary>
        /// <param name="applicationPlatform"> PNS type. </param>
        /// <param name="pnsHandle"> PNS handle. </param>
        /// <param name="registrationId"> Registration id. </param>
        /// <param name="outcome"> Notification outcome. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotificationHubPubRegistrationResult(string applicationPlatform, string pnsHandle, string registrationId, string outcome, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApplicationPlatform = applicationPlatform;
            PnsHandle = pnsHandle;
            RegistrationId = registrationId;
            Outcome = outcome;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> PNS type. </summary>
        public string ApplicationPlatform { get; }
        /// <summary> PNS handle. </summary>
        public string PnsHandle { get; }
        /// <summary> Registration id. </summary>
        public string RegistrationId { get; }
        /// <summary> Notification outcome. </summary>
        public string Outcome { get; }
    }
}
