// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    public partial class NotificationHubPubRegistrationResult : IUtf8JsonSerializable, IJsonModel<NotificationHubPubRegistrationResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NotificationHubPubRegistrationResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NotificationHubPubRegistrationResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NotificationHubPubRegistrationResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NotificationHubPubRegistrationResult)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ApplicationPlatform))
            {
                writer.WritePropertyName("applicationPlatform"u8);
                writer.WriteStringValue(ApplicationPlatform);
            }
            if (options.Format != "W" && Optional.IsDefined(PnsHandle))
            {
                writer.WritePropertyName("pnsHandle"u8);
                writer.WriteStringValue(PnsHandle);
            }
            if (options.Format != "W" && Optional.IsDefined(RegistrationId))
            {
                writer.WritePropertyName("registrationId"u8);
                writer.WriteStringValue(RegistrationId);
            }
            if (options.Format != "W" && Optional.IsDefined(Outcome))
            {
                writer.WritePropertyName("outcome"u8);
                writer.WriteStringValue(Outcome);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        NotificationHubPubRegistrationResult IJsonModel<NotificationHubPubRegistrationResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NotificationHubPubRegistrationResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NotificationHubPubRegistrationResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNotificationHubPubRegistrationResult(document.RootElement, options);
        }

        internal static NotificationHubPubRegistrationResult DeserializeNotificationHubPubRegistrationResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string applicationPlatform = default;
            string pnsHandle = default;
            string registrationId = default;
            string outcome = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("applicationPlatform"u8))
                {
                    applicationPlatform = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("pnsHandle"u8))
                {
                    pnsHandle = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("registrationId"u8))
                {
                    registrationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("outcome"u8))
                {
                    outcome = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NotificationHubPubRegistrationResult(applicationPlatform, pnsHandle, registrationId, outcome, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<NotificationHubPubRegistrationResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NotificationHubPubRegistrationResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NotificationHubPubRegistrationResult)} does not support writing '{options.Format}' format.");
            }
        }

        NotificationHubPubRegistrationResult IPersistableModel<NotificationHubPubRegistrationResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NotificationHubPubRegistrationResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNotificationHubPubRegistrationResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NotificationHubPubRegistrationResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NotificationHubPubRegistrationResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
