// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Private Endpoint Connection properties. </summary>
    public partial class NotificationHubPrivateEndpointConnectionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotificationHubPrivateEndpointConnectionProperties"/>. </summary>
        public NotificationHubPrivateEndpointConnectionProperties()
        {
            GroupIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="NotificationHubPrivateEndpointConnectionProperties"/>. </summary>
        /// <param name="provisioningState"> State of Private Endpoint Connection. </param>
        /// <param name="privateEndpoint"> Represents a Private Endpoint that is connected to Notification Hubs namespace using Private Endpoint Connection. </param>
        /// <param name="groupIds"> List of group ids. For Notification Hubs, it always contains a single "namespace" element. </param>
        /// <param name="connectionState"> State of the Private Link Service connection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotificationHubPrivateEndpointConnectionProperties(NotificationHubsPrivateEndpointConnectionProvisioningState? provisioningState, SubResource privateEndpoint, IReadOnlyList<string> groupIds, RemotePrivateLinkServiceConnectionState connectionState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            PrivateEndpoint = privateEndpoint;
            GroupIds = groupIds;
            ConnectionState = connectionState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> State of Private Endpoint Connection. </summary>
        public NotificationHubsPrivateEndpointConnectionProvisioningState? ProvisioningState { get; set; }
        /// <summary> Represents a Private Endpoint that is connected to Notification Hubs namespace using Private Endpoint Connection. </summary>
        internal SubResource PrivateEndpoint { get; set; }
        /// <summary> Gets Id. </summary>
        public ResourceIdentifier PrivateEndpointId
        {
            get => PrivateEndpoint is null ? default : PrivateEndpoint.Id;
        }

        /// <summary> List of group ids. For Notification Hubs, it always contains a single "namespace" element. </summary>
        public IReadOnlyList<string> GroupIds { get; }
        /// <summary> State of the Private Link Service connection. </summary>
        public RemotePrivateLinkServiceConnectionState ConnectionState { get; set; }
    }
}
